<?php if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Theme Includes
 */
require_once get_template_directory() . '/inc/init.php';

/**
 * TGM Plugin Activation
 */
require_once get_template_directory() . '/TGM-Plugin-Activation/class-tgm-plugin-activation.php';


/**
 * Activate theme Plugins.
 *
 * @internal
 */
function _action_seosight_register_required_plugins() {
	tgmpa( array(
		array(
			'name'         => esc_html__( 'Unyson', 'utouch' ),
			'slug'         => 'unyson',
			'source'       => 'http://up.crumina.net/plugins/unyson.zip', // The plugin source
			'required'     => true,
		),
		array(
			'name'         => esc_attr__( 'King Composer', 'seosight' ),
			'slug'         => 'kingcomposer',
			'required'     => true,
		),
		array(
			'name'         => esc_attr__( 'Frontend Editor', 'seosight' ),
			'slug'         => 'kc_pro',
			'source'       => 'http://kingcomposer.com/downloads/kc_pro.zip', // The plugin source
			'required'     => false,
		),
		array(
			'name'         => esc_attr__( 'Email Subscribers', 'seosight' ),
			'slug'         => 'email-subscribers',
			'required'     => false,
		),
		array(
			'name' => esc_attr__( 'WooCommerce', 'seosight' ),
			'slug' => 'woocommerce',
			'required'     => false,
		),
	) );
}

add_action( 'tgmpa_register', '_action_seosight_register_required_plugins' );

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';


function seosight_admin_customizations() {
	// Load admin panel customizations
	wp_enqueue_style(
		'seosight-admin-custom',
		get_template_directory_uri() . '/css/admin.css',
		array(),
		'1.0'
	);
	wp_enqueue_script(
		'seosight-admin-scripts',
		get_template_directory_uri() . '/js/admin-scripts.js',
		array( 'jquery' ),
		'1.0'
	);
}
add_action( 'admin_enqueue_scripts', 'seosight_admin_customizations' );

function seosight_yoast_kc_compitablity() {
	$active = false;
	if ( is_plugin_active( 'wordpress-seo/wp-seo.php' ) ) {
		$active = true;
	} elseif ( defined( 'WPSEO_VERSION' ) ) {
		$active = true;
	}
	if ( true === $active ) {
		global $pagenow, $typenow;
		if ( empty( $typenow ) && ! empty( $_GET['post'] ) ) {
			$post    = get_post( $_GET['post'] );
			$typenow = $post->post_type;
		}
		if ( ( $pagenow == 'post.php' && $typenow == 'page' ) || ( $pagenow == 'post-new.php' && $typenow == 'page' ) ) {
			wp_enqueue_script( 'crum-yoast-seo', get_template_directory_uri() . '/js/king-yoast.js', array( 'jquery' ), '', true );
		}
	}
}

add_action( 'admin_enqueue_scripts', 'seosight_yoast_kc_compitablity' );